﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;
using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Presentation;
using a = DocumentFormat.OpenXml.Drawing;
using ap = DocumentFormat.OpenXml.ExtendedProperties;
using vt = DocumentFormat.OpenXml.VariantTypes;

namespace PresentationBuilder
{

    public class Program
    {

        public static void Main(string[] args)
        {
            BuildPresentation(@"C:\Test\Test.pptx");
        }

        private static void BuildPresentation(string filePath)
        {
            try
            {
                using (PresentationDocument p = PresentationDocument.Create(filePath, PresentationDocumentType.Presentation))
                {
                    PresentationPart presentationPart = p.AddPresentationPart();
                    PresentationPropertiesPart presPropsPart = presentationPart.AddNewPart<PresentationPropertiesPart>();
                    SlidePart slidePart = presentationPart.AddNewPart<SlidePart>();
                    SlideLayoutPart slideLayoutPart = slidePart.AddNewPart<SlideLayoutPart>();
                    SlideMasterPart slideMasterPart = slideLayoutPart.AddNewPart<SlideMasterPart>();
                    ThemePart themePart = slideMasterPart.AddNewPart<ThemePart>();
                    string relIdLayoutMaster = slideLayoutPart.GetIdOfPart(slideMasterPart);
                    slideMasterPart.AddPart(slideLayoutPart, relIdLayoutMaster);
                    presentationPart.AddPart(slideMasterPart);
                    presentationPart.AddPart(themePart);
                    string relIdPresentationMaster = presentationPart.GetIdOfPart(slideMasterPart);
                    string relIdPresentationSlide = presentationPart.GetIdOfPart(slidePart);
                    GeneratePresentationPart1(relIdPresentationMaster, relIdPresentationSlide).Save(presentationPart);
                    GeneratePresentationPropertiesPart1().Save(presPropsPart);
                    GenerateSlidePart1().Save(slidePart);
                    GenerateSlideLayoutPart1().Save(slideLayoutPart);
                    GenerateSlideMasterPart1(relIdLayoutMaster).Save(slideMasterPart);
                    GenerateThemePart1().Save(themePart);
                    p.Close();
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                Console.ReadLine();
            }
        }

        private static Presentation GeneratePresentationPart1(string slideMasterId, string slideId)
        {
            var element =
                new Presentation(
                    new SlideMasterIdList(
                        new SlideMasterId() { Id = (UInt32Value)2147483648U, RelationshipId = slideMasterId }),
                    new SlideIdList(
                        new SlideId() { Id = (UInt32Value)256U, RelationshipId = slideId }),
                    new SlideSize() { Cx = 9144000, Cy = 6858000, Type = SlideSizeValues.Screen4x3 },
                    new NotesSize() { Cx = 6858000L, Cy = 9144000L }
                    ) { SaveSubsetFonts = true };
            return element;
        }

        private static PresentationProperties GeneratePresentationPropertiesPart1()
        {
            var element =
                new PresentationProperties();
            return element;
        }

        private static Slide GenerateSlidePart1()
        {
            var element =
                new Slide(
                    new CommonSlideData(
                        new ShapeTree(
                            new NonVisualGroupShapeProperties(
                                new NonVisualDrawingProperties() { Id = (UInt32Value)1U, Name = "" },
                                new NonVisualGroupShapeDrawingProperties(),
                                new AppNonVisualDrawingProperties()),
                            new GroupShapeProperties(
                                new a.TransformGroup(
                                    new a.Offset() { X = 0L, Y = 0L },
                                    new a.Extents() { Cx = 0L, Cy = 0L },
                                    new a.ChildOffset() { X = 0L, Y = 0L },
                                    new a.ChildExtents() { Cx = 0L, Cy = 0L })),
                            new Shape(
                                new NonVisualShapeProperties(
                                    new NonVisualDrawingProperties() { Id = (UInt32Value)2U, Name = "Title 1" },
                                    new NonVisualShapeDrawingProperties(
                                        new a.ShapeLocks() { NoGrouping = true }),
                                    new AppNonVisualDrawingProperties(
                                        new PlaceholderShape() { Type = PlaceholderValues.CenteredTitle })),
                                new ShapeProperties(),
                                new TextBody(
                                    new a.BodyProperties(),
                                    new a.ListStyle(),
                                    new a.Paragraph(
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-GB", Dirty = false, SmartTagClean = false },
                                            new a.Text("Slide Title")),
                                        new a.EndParagraphRunProperties() { Language = "en-GB", Dirty = false }))),
                            new Shape(
                                new NonVisualShapeProperties(
                                    new NonVisualDrawingProperties() { Id = (UInt32Value)3U, Name = "Subtitle 2" },
                                    new NonVisualShapeDrawingProperties(
                                        new a.ShapeLocks() { NoGrouping = true }),
                                    new AppNonVisualDrawingProperties(
                                        new PlaceholderShape() { Type = PlaceholderValues.SubTitle, Index = (UInt32Value)1U })),
                                new ShapeProperties(),
                                new TextBody(
                                    new a.BodyProperties(),
                                    new a.ListStyle(),
                                    new a.Paragraph(
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-GB", Dirty = false, SmartTagClean = false },
                                            new a.Text("Slide SubTitle")),
                                        new a.EndParagraphRunProperties() { Language = "en-GB" }))))),
                    new ColorMapOverride(
                        new a.MasterColorMapping()));
            return element;
        }

        private static SlideLayout GenerateSlideLayoutPart1()
        {
            var element =
                new SlideLayout(
                    new CommonSlideData(
                        new ShapeTree(
                            new NonVisualGroupShapeProperties(
                                new NonVisualDrawingProperties() { Id = (UInt32Value)1U, Name = "" },
                                new NonVisualGroupShapeDrawingProperties(),
                                new AppNonVisualDrawingProperties()),
                            new GroupShapeProperties(
                                new a.TransformGroup(
                                    new a.Offset() { X = 0L, Y = 0L },
                                    new a.Extents() { Cx = 0L, Cy = 0L },
                                    new a.ChildOffset() { X = 0L, Y = 0L },
                                    new a.ChildExtents() { Cx = 0L, Cy = 0L })),
                            new Shape(
                                new NonVisualShapeProperties(
                                    new NonVisualDrawingProperties() { Id = (UInt32Value)2U, Name = "Title 1" },
                                    new NonVisualShapeDrawingProperties(
                                        new a.ShapeLocks() { NoGrouping = true }),
                                    new AppNonVisualDrawingProperties(
                                        new PlaceholderShape() { Type = PlaceholderValues.CenteredTitle })),
                                new ShapeProperties(
                                    new a.Transform2D(
                                        new a.Offset() { X = 685800L, Y = 2130425L },
                                        new a.Extents() { Cx = 7772400L, Cy = 1470025L })),
                                new TextBody(
                                    new a.BodyProperties(),
                                    new a.ListStyle(),
                                    new a.Paragraph(
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-US", SmartTagClean = false },
                                            new a.Text("Click to edit Master title style")),
                                        new a.EndParagraphRunProperties() { Language = "en-US" }))),
                            new Shape(
                                new NonVisualShapeProperties(
                                    new NonVisualDrawingProperties() { Id = (UInt32Value)3U, Name = "Subtitle 2" },
                                    new NonVisualShapeDrawingProperties(
                                        new a.ShapeLocks() { NoGrouping = true }),
                                    new AppNonVisualDrawingProperties(
                                        new PlaceholderShape() { Type = PlaceholderValues.SubTitle, Index = (UInt32Value)1U })),
                                new ShapeProperties(
                                    new a.Transform2D(
                                        new a.Offset() { X = 1371600L, Y = 3886200L },
                                        new a.Extents() { Cx = 6400800L, Cy = 1752600L })),
                                new TextBody(
                                    new a.BodyProperties(),
                                    new a.ListStyle(
                                        new a.Level1ParagraphProperties(
                                            new a.NoBullet(),
                                            new a.DefaultRunProperties(
                                                new a.SolidFill(
                                                    new a.SchemeColor(
                                                        new a.Tint() { Val = 75000 }
                                                    ) { Val = a.SchemeColorValues.Text1 }))
                                        ) { LeftMargin = 0, Indent = 0, Alignment = a.TextAlignValues.Center }),
                                    new a.Paragraph(
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-US", SmartTagClean = false },
                                            new a.Text("Click to edit Master subtitle style")),
                                        new a.EndParagraphRunProperties() { Language = "en-US" }))))
                    ) { Name = "Title Slide" },
                    new ColorMapOverride(
                        new a.MasterColorMapping())
                ) { Type = SlideLayoutValues.Title, Preserve = true };
            return element;
        }

        private static SlideMaster GenerateSlideMasterPart1(string slideLayoutPartId)
        {
            var element =
                new SlideMaster(
                    new CommonSlideData(
                        new Background(
                            new BackgroundStyleReference(
                                new a.SchemeColor() { Val = a.SchemeColorValues.Background1 }
                            ) { Index = (UInt32Value)1001U }),
                        new ShapeTree(
                            new NonVisualGroupShapeProperties(
                                new NonVisualDrawingProperties() { Id = (UInt32Value)1U, Name = "" },
                                new NonVisualGroupShapeDrawingProperties(),
                                new AppNonVisualDrawingProperties()),
                            new GroupShapeProperties(
                                new a.TransformGroup(
                                    new a.Offset() { X = 0L, Y = 0L },
                                    new a.Extents() { Cx = 0L, Cy = 0L },
                                    new a.ChildOffset() { X = 0L, Y = 0L },
                                    new a.ChildExtents() { Cx = 0L, Cy = 0L })),
                            new Shape(
                                new NonVisualShapeProperties(
                                    new NonVisualDrawingProperties() { Id = (UInt32Value)2U, Name = "Title Placeholder 1" },
                                    new NonVisualShapeDrawingProperties(
                                        new a.ShapeLocks() { NoGrouping = true }),
                                    new AppNonVisualDrawingProperties(
                                        new PlaceholderShape() { Type = PlaceholderValues.Title })),
                                new ShapeProperties(
                                    new a.Transform2D(
                                        new a.Offset() { X = 457200L, Y = 274638L },
                                        new a.Extents() { Cx = 8229600L, Cy = 1143000L }),
                                    new a.PresetGeometry(
                                        new a.AdjustValueList()
                                    ) { Preset = a.ShapeTypeValues.Rectangle }),
                                new TextBody(
                                    new a.BodyProperties(
                                        new a.NormalAutoFit()
                                    ) { Vertical = a.TextVerticalValues.Horizontal, LeftInset = 91440, TopInset = 45720, RightInset = 91440, BottomInset = 45720, RightToLeftColumns = false, Anchor = a.TextAnchoringValues.Center },
                                    new a.ListStyle(),
                                    new a.Paragraph(
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-US", SmartTagClean = false },
                                            new a.Text("Click to edit Master title style")),
                                        new a.EndParagraphRunProperties() { Language = "en-US" }))),
                            new Shape(
                                new NonVisualShapeProperties(
                                    new NonVisualDrawingProperties() { Id = (UInt32Value)3U, Name = "Text Placeholder 2" },
                                    new NonVisualShapeDrawingProperties(
                                        new a.ShapeLocks() { NoGrouping = true }),
                                    new AppNonVisualDrawingProperties(
                                        new PlaceholderShape() { Type = PlaceholderValues.Body, Index = (UInt32Value)1U })),
                                new ShapeProperties(
                                    new a.Transform2D(
                                        new a.Offset() { X = 457200L, Y = 1600200L },
                                        new a.Extents() { Cx = 8229600L, Cy = 4525963L }),
                                    new a.PresetGeometry(
                                        new a.AdjustValueList()
                                    ) { Preset = a.ShapeTypeValues.Rectangle }),
                                new TextBody(
                                    new a.BodyProperties(
                                        new a.NormalAutoFit()
                                    ) { Vertical = a.TextVerticalValues.Horizontal, LeftInset = 91440, TopInset = 45720, RightInset = 91440, BottomInset = 45720, RightToLeftColumns = false },
                                    new a.ListStyle(),
                                    new a.Paragraph(
                                        new a.ParagraphProperties() { Level = 0 },
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-US", SmartTagClean = false },
                                            new a.Text("Click to edit Master text styles"))),
                                    new a.Paragraph(
                                        new a.ParagraphProperties() { Level = 1 },
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-US", SmartTagClean = false },
                                            new a.Text("Second level"))),
                                    new a.Paragraph(
                                        new a.ParagraphProperties() { Level = 2 },
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-US", SmartTagClean = false },
                                            new a.Text("Third level"))),
                                    new a.Paragraph(
                                        new a.ParagraphProperties() { Level = 3 },
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-US", SmartTagClean = false },
                                            new a.Text("Fourth level"))),
                                    new a.Paragraph(
                                        new a.ParagraphProperties() { Level = 4 },
                                        new a.Run(
                                            new a.RunProperties() { Language = "en-US", SmartTagClean = false },
                                            new a.Text("Fifth level")),
                                        new a.EndParagraphRunProperties() { Language = "en-US" }))))),
                    new ColorMap() { Background1 = a.ColorSchemeIndexValues.Light1, Text1 = a.ColorSchemeIndexValues.Dark1, Background2 = a.ColorSchemeIndexValues.Light2, Text2 = a.ColorSchemeIndexValues.Dark2, Accent1 = a.ColorSchemeIndexValues.Accent1, Accent2 = a.ColorSchemeIndexValues.Accent2, Accent3 = a.ColorSchemeIndexValues.Accent3, Accent4 = a.ColorSchemeIndexValues.Accent4, Accent5 = a.ColorSchemeIndexValues.Accent5, Accent6 = a.ColorSchemeIndexValues.Accent6, Hyperlink = a.ColorSchemeIndexValues.Hyperlink, FollowedHyperlink = a.ColorSchemeIndexValues.FollowedHyperlink },
                    new SlideLayoutIdList(
                        new SlideLayoutId() { Id = (UInt32Value)2147483649U, RelationshipId = slideLayoutPartId }),
                    new TextStyles(
                        new TitleStyle(
                            new a.Level1ParagraphProperties(
                                new a.SpaceBefore(
                                    new a.SpacingPercent() { Val = 0 }),
                                new a.NoBullet(),
                                new a.DefaultRunProperties(
                                    new a.SolidFill(
                                        new a.SchemeColor() { Val = a.SchemeColorValues.Text1 }),
                                    new a.LatinFont() { Typeface = "+mj-lt" },
                                    new a.EastAsianFont() { Typeface = "+mj-ea" },
                                    new a.ComplexScriptFont() { Typeface = "+mj-cs" }
                                ) { FontSize = 4400, Kerning = 1200 }
                            ) { Alignment = a.TextAlignValues.Center, DefaultTabSize = 914400, RightToLeft = false, EastAsianLineBreak = true, LatinLineBreak = false, Height = true }),
                        new BodyStyle(
                            new a.Level1ParagraphProperties(
                                new a.SpaceBefore(
                                    new a.SpacingPercent() { Val = 20000 }),
                                new a.BulletFont() { Typeface = "Arial", PitchFamily = 34, CharacterSet = 0 },
                                new a.CharacterBullet() { Char = "•" },
                                new a.DefaultRunProperties(
                                    new a.SolidFill(
                                        new a.SchemeColor() { Val = a.SchemeColorValues.Text1 }),
                                    new a.LatinFont() { Typeface = "+mn-lt" },
                                    new a.EastAsianFont() { Typeface = "+mn-ea" },
                                    new a.ComplexScriptFont() { Typeface = "+mn-cs" }
                                ) { FontSize = 3200, Kerning = 1200 }
                            ) { LeftMargin = 342900, Indent = -342900, Alignment = a.TextAlignValues.Left, DefaultTabSize = 914400, RightToLeft = false, EastAsianLineBreak = true, LatinLineBreak = false, Height = true }),
                        new OtherStyle(
                            new a.DefaultParagraphProperties(
                                new a.DefaultRunProperties() { Language = "en-US" }),
                            new a.Level1ParagraphProperties(
                                new a.DefaultRunProperties(
                                    new a.SolidFill(
                                        new a.SchemeColor() { Val = a.SchemeColorValues.Text1 }),
                                    new a.LatinFont() { Typeface = "+mn-lt" },
                                    new a.EastAsianFont() { Typeface = "+mn-ea" },
                                    new a.ComplexScriptFont() { Typeface = "+mn-cs" }
                                ) { FontSize = 1800, Kerning = 1200 }
                            ) { LeftMargin = 0, Alignment = a.TextAlignValues.Left, DefaultTabSize = 914400, RightToLeft = false, EastAsianLineBreak = true, LatinLineBreak = false, Height = true })));
            return element;
        }

        private static a.Theme GenerateThemePart1()
        {
            var element =
                new a.Theme(
                    new a.ThemeElements(
                        new a.ColorScheme(
                            new a.Dark1Color(
                                new a.SystemColor() { Val = a.SystemColorValues.WindowText, LastColor = "000000" }),
                            new a.Light1Color(
                                new a.SystemColor() { Val = a.SystemColorValues.Window, LastColor = "FFFFFF" }),
                            new a.Dark2Color(
                                new a.RgbColorModelHex() { Val = "1F497D" }),
                            new a.Light2Color(
                                new a.RgbColorModelHex() { Val = "EEECE1" }),
                            new a.Accent1Color(
                                new a.RgbColorModelHex() { Val = "4F81BD" }),
                            new a.Accent2Color(
                                new a.RgbColorModelHex() { Val = "C0504D" }),
                            new a.Accent3Color(
                                new a.RgbColorModelHex() { Val = "9BBB59" }),
                            new a.Accent4Color(
                                new a.RgbColorModelHex() { Val = "8064A2" }),
                            new a.Accent5Color(
                                new a.RgbColorModelHex() { Val = "4BACC6" }),
                            new a.Accent6Color(
                                new a.RgbColorModelHex() { Val = "F79646" }),
                            new a.Hyperlink(
                                new a.RgbColorModelHex() { Val = "0000FF" }),
                            new a.FollowedHyperlinkColor(
                                new a.RgbColorModelHex() { Val = "800080" })
                        ) { Name = "Office" },
                        new a.FontScheme(
                            new a.MajorFont(
                                new a.LatinFont() { Typeface = "Calibri" },
                                new a.EastAsianFont() { Typeface = "" },
                                new a.ComplexScriptFont() { Typeface = "" }),
                            new a.MinorFont(
                                new a.LatinFont() { Typeface = "Calibri" },
                                new a.EastAsianFont() { Typeface = "" },
                                new a.ComplexScriptFont() { Typeface = "" })
                        ) { Name = "Office" },
                        new a.FormatScheme(
                            new a.FillStyleList(
                                new a.SolidFill(
                                    new a.SchemeColor() { Val = a.SchemeColorValues.PhColor }),
                                new a.GradientFill(
                                    new a.GradientStopList(
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Tint() { Val = 50000 },
                                                new a.SaturationModulation() { Val = 300000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 0 },
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Tint() { Val = 37000 },
                                                new a.SaturationModulation() { Val = 300000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 35000 },
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Tint() { Val = 15000 },
                                                new a.SaturationModulation() { Val = 350000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 100000 }),
                                    new a.LinearGradientFill() { Angle = 16200000, Scaled = true }
                                ) { RotateWithShape = true },
                                new a.GradientFill(
                                    new a.GradientStopList(
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Shade() { Val = 51000 },
                                                new a.SaturationModulation() { Val = 130000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 0 },
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Shade() { Val = 93000 },
                                                new a.SaturationModulation() { Val = 130000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 80000 },
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Shade() { Val = 94000 },
                                                new a.SaturationModulation() { Val = 135000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 100000 }),
                                    new a.LinearGradientFill() { Angle = 16200000, Scaled = false }
                                ) { RotateWithShape = true }),
                            new a.LineStyleList(
                                new a.Outline(
                                    new a.SolidFill(
                                        new a.SchemeColor(
                                            new a.Shade() { Val = 95000 },
                                            new a.SaturationModulation() { Val = 105000 }
                                        ) { Val = a.SchemeColorValues.PhColor }),
                                    new a.PresetDash() { Val = a.PresetLineDashValues.Solid }
                                ) { Width = 9525, CapType = a.LineCapValues.Flat, CompoundLineType = a.CompoundLineValues.Single, Alignment = a.PenAlignmentValues.Center },
                                new a.Outline(
                                    new a.SolidFill(
                                        new a.SchemeColor() { Val = a.SchemeColorValues.PhColor }),
                                    new a.PresetDash() { Val = a.PresetLineDashValues.Solid }
                                ) { Width = 25400, CapType = a.LineCapValues.Flat, CompoundLineType = a.CompoundLineValues.Single, Alignment = a.PenAlignmentValues.Center },
                                new a.Outline(
                                    new a.SolidFill(
                                        new a.SchemeColor() { Val = a.SchemeColorValues.PhColor }),
                                    new a.PresetDash() { Val = a.PresetLineDashValues.Solid }
                                ) { Width = 38100, CapType = a.LineCapValues.Flat, CompoundLineType = a.CompoundLineValues.Single, Alignment = a.PenAlignmentValues.Center }),
                            new a.EffectStyleList(
                                new a.EffectStyle(
                                    new a.EffectList(
                                        new a.OuterShadow(
                                            new a.RgbColorModelHex(
                                                new a.Alpha() { Val = 38000 }
                                            ) { Val = "000000" }
                                        ) { BlurRadius = 40000L, Distance = 20000L, Direction = 5400000, RotateWithShape = false })),
                                new a.EffectStyle(
                                    new a.EffectList(
                                        new a.OuterShadow(
                                            new a.RgbColorModelHex(
                                                new a.Alpha() { Val = 35000 }
                                            ) { Val = "000000" }
                                        ) { BlurRadius = 40000L, Distance = 23000L, Direction = 5400000, RotateWithShape = false })),
                                new a.EffectStyle(
                                    new a.EffectList(
                                        new a.OuterShadow(
                                            new a.RgbColorModelHex(
                                                new a.Alpha() { Val = 35000 }
                                            ) { Val = "000000" }
                                        ) { BlurRadius = 40000L, Distance = 23000L, Direction = 5400000, RotateWithShape = false }),
                                    new a.Scene3D(
                                        new a.Camera(
                                            new a.Rotation() { Latitude = 0, Longitude = 0, Revolution = 0 }
                                        ) { Preset = a.PresetCameraValues.OrthographicFront },
                                        new a.LightRig(
                                            new a.Rotation() { Latitude = 0, Longitude = 0, Revolution = 1200000 }
                                        ) { Rig = a.LightRigValues.ThreePoints, Direction = a.LightRigDirectionValues.Top }),
                                    new a.Shape3D(
                                        new a.BevelTop() { Width = 63500L, Height = 25400L }))),
                            new a.BackgroundFillStyleList(
                                new a.SolidFill(
                                    new a.SchemeColor() { Val = a.SchemeColorValues.PhColor }),
                                new a.GradientFill(
                                    new a.GradientStopList(
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Tint() { Val = 40000 },
                                                new a.SaturationModulation() { Val = 350000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 0 },
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Tint() { Val = 45000 },
                                                new a.Shade() { Val = 99000 },
                                                new a.SaturationModulation() { Val = 350000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 40000 },
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Shade() { Val = 20000 },
                                                new a.SaturationModulation() { Val = 255000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 100000 }),
                                    new a.PathGradientFill(
                                        new a.FillToRectangle() { Left = 50000, Top = -80000, Right = 50000, Bottom = 180000 }
                                    ) { Path = a.PathShadeValues.Circle }
                                ) { RotateWithShape = true },
                                new a.GradientFill(
                                    new a.GradientStopList(
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Tint() { Val = 80000 },
                                                new a.SaturationModulation() { Val = 300000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 0 },
                                        new a.GradientStop(
                                            new a.SchemeColor(
                                                new a.Shade() { Val = 30000 },
                                                new a.SaturationModulation() { Val = 200000 }
                                            ) { Val = a.SchemeColorValues.PhColor }
                                        ) { Position = 100000 }),
                                    new a.PathGradientFill(
                                        new a.FillToRectangle() { Left = 50000, Top = 50000, Right = 50000, Bottom = 50000 }
                                    ) { Path = a.PathShadeValues.Circle }
                                ) { RotateWithShape = true })
                        ) { Name = "Office" }),
                    new a.ObjectDefaults(),
                    new a.ExtraColorSchemeList()
                ) { Name = "Office Theme" };
            return element;
        }

    }

}